;original java code by Mitchell Whitelaw -> http://www.openprocessing.org/sketch/8752
#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so /pe /rm
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"

#include <GUIConstantsEx.au3>
#include <GDIPlus.au3>

_GDIPlus_Startup()

Global Const $iW = 1000, $iH = 800, $fRad = 180 / ACos(-1), $fRad03 = 0.3 * $fRad, $fRad06 = 0.6 * $fRad, $iH8 = $iH / 8
Global Const $iRecursionLevel = 15

Global Const $hGUI = GUICreate("GDI+ Recursive Tree converted to AutoIt by UEZ", $iW, $iH)
GUISetBkColor(0xFFFFFF, $hgui)
GUISetState()

Global Const $hGfxHwnd = _GDIPlus_GraphicsCreateFromHWND($hGUI)
Global Const $hBitmap = _GDIPlus_BitmapCreateFromGraphics($iW, $iH, $hGfxHwnd)
Global Const $hGfxCtxt = _GDIPlus_ImageGetGraphicsContext($hBitmap)
_GDIPlus_GraphicsSetSmoothingMode($hGfxCtxt, $GDIP_SMOOTHINGMODE_ANTIALIAS8X4 + (@OSBuild > 5999))
;~ _GDIPlus_GraphicsSetInterpolationMode($hGfxCtxt, 7)

Global $iPenSize = 10, $fScale = 0.725, $iRL = 0, $hMatrix, $iRL, $bDone = False
Global Const $hPen = _GDIPlus_PenCreate(0xFF3D1F1C, $iPenSize)

Draw()
ConsoleWrite("Recursion calls: " & $iRL & @CRLF)

HotKeySet("{F10}", "Save_Bitmap")

Do
	Switch GUIGetMsg()
		Case $GUI_EVENT_PRIMARYDOWN
			$bDone = False
			$iRL = 0
			Draw()
			$bDone = True
			ConsoleWrite("Recursion calls: " & $iRL & @CRLF)
		Case $GUI_EVENT_CLOSE
			ExitLoop
	EndSwitch
Until False

_GDIPlus_MatrixDispose($hMatrix)
_GDIPlus_PenDispose($hPen)
_GDIPlus_GraphicsDispose($hGfxCtxt)
_GDIPlus_GraphicsDispose($hGfxHwnd)
_GDIPlus_BitmapDispose($hBitmap)
_GDIPlus_Shutdown()
GUIDelete()
Exit

Func Draw()
	Local $iMouseCursor = MouseGetCursor ()
	GUISetCursor(15, 1, $hGUI)
	_GDIPlus_GraphicsClear($hGfxCtxt, 0xFFF8F8F8)
	$hMatrix = _GDIPlus_MatrixCreate()
	_GDIPlus_MatrixTranslate($hMatrix, $iW / 2, $iH - 10)
	_GDIPlus_GraphicsSetTransform($hGfxCtxt, $hMatrix)
	Local $te, $t = TimerInit()
	Recursive_Tree(0)
	$te = Round(TimerDiff($t), 2)
	_GDIPlus_MatrixDispose($hMatrix)
	_GDIPlus_GraphicsDrawImageRect($hGfxHwnd, $hBitmap, 0, 0, $iW, $iH)
	_GDIPlus_GraphicsDrawString($hGfxHwnd, "Click lmb to create new tree! F10 to save image!", 4, $iH - 18)
	_GDIPlus_GraphicsDrawString($hGfxHwnd, "Tree created in " & $te & " ms.", 4, 4)
	GUISetCursor($iMouseCursor, 1, $hGUI)
EndFunc

Func Save_Bitmap()
	If $bDone And WinActive($hGUI) Then
		Local $sFilename = @ScriptDir & "\Tree_" & @YEAR & @MON & @MDAY & "_" & @HOUR & @MIN & @SEC & ".png"
		If _GDIPlus_ImageSaveToFile($hBitmap, $sFilename) Then MsgBox(64, "Information", "Bitmap saved to " & $sFilename)
	EndIf
EndFunc

Func Recursive_Tree($level)
	$iRL += 1
	If $level < $iRecursionLevel + 1 Then
		If $level > $iRecursionLevel - 5 Then
			DllCall($__g_hGDIPDll, "int", "GdipSetPenColor", "handle", $hPen, "dword", 0xE0360000 + 0x100 * (Int(0x69 * Random(0.5, 1.25))) + 0x26)
			DllCall($__g_hGDIPDll, "int", "GdipSetPenWidth", "handle", $hPen, "float", $iPenSize + Random(1, 2, 1))
		Else
;~ 			DllCall($__g_hGDIPDll, "int", "GdipSetPenColor", "handle", $hPen, "dword", 0xFF3D1F1C)
			Local Const $c = Random(50, 100, 1)
			DllCall($__g_hGDIPDll, "int", "GdipSetPenColor", "handle", $hPen, "dword", 0xFF000000 + 0x10000 * $c + $c / 3)
			DllCall($__g_hGDIPDll, "int", "GdipSetPenWidth", "handle", $hPen, "float", $iPenSize)
		EndIf
		DllCall($__g_hGDIPDll, "int", "GdipDrawLine", "handle", $hGfxCtxt, "handle", $hPen, "float", 0, "float", 0, "float", 0, "float", -$iH8 - 1)
		DllCall($__g_hGDIPDll, "int", "GdipTranslateMatrix", "handle", $hMatrix, "float", 0, "float", -$iH8, "int", False)
		DllCall($__g_hGDIPDll, "int", "GdipRotateMatrix", "handle", $hMatrix, "float", Random(-0.1, 0.1) * $fRad, "int", False)
		DllCall($__g_hGDIPDll, "int", "GdipSetWorldTransform", "handle", $hGfxCtxt, "handle", $hMatrix)

		If Random(0, 1) < 0.6667 Then
			DllCall($__g_hGDIPDll, "int", "GdipRotateMatrix", "handle", $hMatrix, "float", $fRad03, "int", False)
			DllCall($__g_hGDIPDll, "int", "GdipScaleMatrix", "handle", $hMatrix, "float", $fScale, "float", $fScale, "int", False)
			DllCall($__g_hGDIPDll, "int", "GdipSetWorldTransform", "handle", $hGfxCtxt, "handle", $hMatrix)

			Local $hMatrix_Clone = DllCall($__g_hGDIPDll, "int", "GdipCloneMatrix", "handle", $hMatrix, "handle*", 0)[2]
			Local $iPenSize_Clone = $iPenSize
			$iPenSize *= $fScale
			Recursive_Tree($level + 1)
			DllCall($__g_hGDIPDll, "int", "GdipDeleteMatrix", "handle", $hMatrix)
			$hMatrix = $hMatrix_Clone
			$iPenSize = $iPenSize_Clone

			DllCall($__g_hGDIPDll, "int", "GdipRotateMatrix", "handle", $hMatrix, "float", -$fRad06, "int", False)
			DllCall($__g_hGDIPDll, "int", "GdipSetWorldTransform", "handle", $hGfxCtxt, "handle", $hMatrix)

			$hMatrix_Clone = DllCall($__g_hGDIPDll, "int", "GdipCloneMatrix", "handle", $hMatrix, "handle*", 0)[2]
			$iPenSize_Clone = $iPenSize
			$iPenSize *= $fScale
			Recursive_Tree($level + 1)
			DllCall($__g_hGDIPDll, "int", "GdipDeleteMatrix", "handle", $hMatrix)
			$hMatrix = $hMatrix_Clone
			$iPenSize = $iPenSize_Clone
		Else
			Recursive_Tree($level)
		EndIf
	EndIf
EndFunc